class TemplateManager {
  constructor(imageGenerator) {
    this.imageGenerator = imageGenerator;
    this.templates = {
      simple: {
        name: '简约',
        preview: 'assets/templates/simple.png'
      }
    };
  }

  async getAllTemplates() {
    return this.templates;
  }

  setTemplate(id) {
    const template = this.templates[id];
    if (!template) {
      throw new Error(`Template ${id} not found`);
    }
    this.currentTemplate = template;
  }
}

export default TemplateManager; 