// 字体加载器
class FontLoader {
  static async load(fontFamily, url) {
    try {
      const font = new FontFace(fontFamily, `url(${url})`);
      await font.load();
      document.fonts.add(font);
      return true;
    } catch (error) {
      Logger.error('加载字体失败:', error);
      return false;
    }
  }
}

export default FontLoader; 