// 错误处理器
class ErrorHandler {
  // 错误类型枚举
  static errorTypes = {
    FONT_LOAD_ERROR: 'FONT_LOAD_ERROR',
    RENDER_ERROR: 'RENDER_ERROR',
    EXPORT_ERROR: 'EXPORT_ERROR',
    CLIPBOARD_ERROR: 'CLIPBOARD_ERROR',
    DOWNLOAD_ERROR: 'DOWNLOAD_ERROR'
  };

  // 处理错误
  static handle(error, type) {
    // 记录错误
    console.error(`[${type}]`, error);

    // 根据错误类型返回用户友好的错误信息
    switch (type) {
      case this.errorTypes.FONT_LOAD_ERROR:
        return new Error('加载字体失败，请检查网络连接');
      case this.errorTypes.RENDER_ERROR:
        return new Error('生成图片失败，请重试');
      case this.errorTypes.EXPORT_ERROR:
        return new Error('导出图片失败，请重试');
      case this.errorTypes.CLIPBOARD_ERROR:
        return new Error('复制到剪贴板失败，请重试');
      case this.errorTypes.DOWNLOAD_ERROR:
        return new Error('下载图片失败，请重试');
      default:
        return new Error('发生未知错误，请重试');
    }
  }
}

export default ErrorHandler; 