// 扩展后台脚本
class BackgroundApp {
  constructor() {
    this.init();
  }

  init() {
    // 监听消息
    chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
      switch (message.type) {
        case 'TEXT_SELECTED':
          this.handleTextSelected(message.data, sender.tab.id);
          break;
          
        case 'GET_SELECTED_TEXT':
          this.handleGetSelectedText(sender.tab.id, sendResponse);
          return true;
          
        case 'OPEN_GENERATOR':
          this.handleOpenGenerator(message.data);
          break;
      }
    });
  }

  // 处理文本选择
  async handleTextSelected(data, tabId) {
    try {
      await chrome.storage.local.set({
        selectedText: data.text,
        selectedTabId: tabId,
        timestamp: Date.now()  // 添加时间戳
      });
    } catch (error) {
      console.error('保存选中文本失败:', error);
    }
  }

  // 处理获取选中文本
  async handleGetSelectedText(tabId, sendResponse) {
    try {
      const data = await chrome.storage.local.get(['selectedText', 'selectedTabId', 'timestamp']);
      // 只返回同一个标签页的文本，且时间不超过5分钟
      if (data.selectedTabId === tabId && 
          data.timestamp && 
          Date.now() - data.timestamp < 5 * 60 * 1000) {
        sendResponse({ text: data.selectedText });
      } else {
        sendResponse({ text: '' });
      }
    } catch (error) {
      console.error('获取选中文本失败:', error);
      sendResponse({ text: '' });
    }
  }

  // 处理打开生成器
  async handleOpenGenerator(data) {
    try {
      await chrome.storage.local.set({
        selectedText: data.text,
        timestamp: Date.now()
      });
      chrome.action.openPopup();
    } catch (error) {
      console.error('打开生成器失败:', error);
    }
  }
}

// 初始化后台应用
new BackgroundApp(); 